/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.AddressSpace;
import dioscuri.module.cpu32.CodeBlock;
import dioscuri.module.cpu32.HardwareComponent;
import dioscuri.module.cpu32.Memory;
import dioscuri.module.cpu32.PhysicalAddressSpace;
import dioscuri.module.cpu32.Processor;
import dioscuri.module.cpu32.ProcessorException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class LinearAddressSpace
extends AddressSpace
implements HardwareComponent {
    private static final PageFaultWrapper PF_NOT_PRESENT_RU = new PageFaultWrapper(4);
    private static final PageFaultWrapper PF_NOT_PRESENT_RS = new PageFaultWrapper(0);
    private static final PageFaultWrapper PF_NOT_PRESENT_WU = new PageFaultWrapper(6);
    private static final PageFaultWrapper PF_NOT_PRESENT_WS = new PageFaultWrapper(2);
    private static final PageFaultWrapper PF_PROTECTION_VIOLATION_RU = new PageFaultWrapper(5);
    private static final PageFaultWrapper PF_PROTECTION_VIOLATION_RS = new PageFaultWrapper(1);
    private static final PageFaultWrapper PF_PROTECTION_VIOLATION_WU = new PageFaultWrapper(7);
    private static final PageFaultWrapper PF_PROTECTION_VIOLATION_WS = new PageFaultWrapper(3);
    private static final byte FOUR_M_GLOBAL = 3;
    private static final byte FOUR_M = 2;
    private static final byte FOUR_K_GLOBAL = 1;
    private static final byte FOUR_K = 0;
    private static final byte IS_GLOBAL_MASK = 1;
    private static final byte IS_4_M_MASK = 2;
    private boolean isSupervisor;
    private boolean globalPagesEnabled = false;
    private boolean pagingDisabled = true;
    private boolean pageCacheEnabled;
    private boolean writeProtectUserPages = false;
    private boolean pageSizeExtensions = false;
    private int baseAddress = 0;
    private int lastAddress = 0;
    private AddressSpace target;
    private byte[] pageFlags;
    private Hashtable<Integer, Integer> nonGlobalPages = new Hashtable();
    private Memory[] readUserIndex;
    private Memory[] readSupervisorIndex;
    private Memory[] writeUserIndex;
    private Memory[] writeSupervisorIndex;
    private Memory[] readIndex;
    private Memory[] writeIndex;

    public LinearAddressSpace() {
        this.pageFlags = new byte[0x100000];
        for (int i = 0; i < 0x100000; ++i) {
            this.pageFlags[i] = 0;
        }
        this.readUserIndex = null;
        this.readSupervisorIndex = null;
        this.writeUserIndex = null;
        this.writeSupervisorIndex = null;
    }

    @Override
    public void dumpState(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.isSupervisor);
        dataOutput.writeBoolean(this.globalPagesEnabled);
        dataOutput.writeBoolean(this.pagingDisabled);
        dataOutput.writeBoolean(this.pageCacheEnabled);
        dataOutput.writeBoolean(this.writeProtectUserPages);
        dataOutput.writeBoolean(this.pageSizeExtensions);
        dataOutput.writeInt(this.baseAddress);
        dataOutput.writeInt(this.lastAddress);
        dataOutput.writeInt(this.pageFlags.length);
        dataOutput.write(this.pageFlags);
        dataOutput.writeInt(this.nonGlobalPages.size());
        Enumeration<Integer> enumeration = this.nonGlobalPages.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = enumeration.nextElement();
            Integer n2 = this.nonGlobalPages.get(n);
            dataOutput.writeInt(n);
            dataOutput.writeInt(n2);
        }
        this.dumpMemory(dataOutput, this.readUserIndex);
        this.dumpMemory(dataOutput, this.readSupervisorIndex);
        this.dumpMemory(dataOutput, this.writeUserIndex);
        this.dumpMemory(dataOutput, this.writeSupervisorIndex);
    }

    private void dumpMemory(DataOutput dataOutput, Memory[] memoryArray) throws IOException {
        byte[] byArray = new byte[]{};
        if (memoryArray == null) {
            dataOutput.writeInt(0);
        } else {
            dataOutput.writeInt(memoryArray.length);
            for (int i = 0; i < memoryArray.length; ++i) {
                if (memoryArray[i] == null) {
                    dataOutput.writeLong(-1L);
                    continue;
                }
                long l = memoryArray[i].getSize();
                if (byArray.length < (int)l) {
                    byArray = new byte[(int)l];
                }
                if (memoryArray[i].isAllocated()) {
                    try {
                        memoryArray[i].copyContentsInto(0, byArray, 0, (int)l);
                    }
                    catch (IllegalStateException illegalStateException) {
                        l = 0L;
                    }
                    dataOutput.writeLong(l);
                    if (l <= 0L) continue;
                    dataOutput.write(byArray);
                    continue;
                }
                dataOutput.writeLong(0L);
            }
        }
    }

    @Override
    public void loadState(DataInput dataInput) throws IOException {
        this.reset();
        this.isSupervisor = dataInput.readBoolean();
        this.globalPagesEnabled = dataInput.readBoolean();
        this.pagingDisabled = dataInput.readBoolean();
        this.pageCacheEnabled = dataInput.readBoolean();
        this.writeProtectUserPages = dataInput.readBoolean();
        this.pageSizeExtensions = dataInput.readBoolean();
        this.baseAddress = dataInput.readInt();
        this.lastAddress = dataInput.readInt();
        int n = dataInput.readInt();
        this.pageFlags = new byte[n];
        dataInput.readFully(this.pageFlags, 0, n);
        this.nonGlobalPages.clear();
        int n2 = dataInput.readInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = dataInput.readInt();
            int n4 = dataInput.readInt();
            this.nonGlobalPages.put(new Integer(n3), new Integer(n4));
        }
        n = dataInput.readInt();
        n = dataInput.readInt();
        n = dataInput.readInt();
        n = dataInput.readInt();
        this.setSupervisor(this.isSupervisor);
    }

    private void loadMemory(DataInput dataInput, Memory[] memoryArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            long l = dataInput.readLong();
            if (l >= 0L) {
                System.out.println(l);
                byte[] byArray = new byte[(int)l];
                dataInput.readFully(byArray, 0, (int)l);
                memoryArray[i].copyContentsFrom(0, byArray, 0, (int)l);
                continue;
            }
            memoryArray[i] = null;
        }
    }

    private Memory[] getReadIndex() {
        if (this.isSupervisor) {
            this.readSupervisorIndex = new Memory[0x100000];
            this.readIndex = this.readSupervisorIndex;
            return this.readSupervisorIndex;
        }
        this.readUserIndex = new Memory[0x100000];
        this.readIndex = this.readUserIndex;
        return this.readUserIndex;
    }

    private Memory[] getWriteIndex() {
        if (this.isSupervisor) {
            this.writeSupervisorIndex = new Memory[0x100000];
            this.writeIndex = this.writeSupervisorIndex;
            return this.writeSupervisorIndex;
        }
        this.writeUserIndex = new Memory[0x100000];
        this.writeIndex = this.writeUserIndex;
        return this.writeUserIndex;
    }

    private void setReadIndexValue(int n, Memory memory) {
        try {
            this.readIndex[n] = memory;
        }
        catch (NullPointerException nullPointerException) {
            this.getReadIndex()[n] = memory;
        }
    }

    private Memory getReadIndexValue(int n) {
        try {
            return this.readIndex[n];
        }
        catch (NullPointerException nullPointerException) {
            return this.getReadIndex()[n];
        }
    }

    private void setWriteIndexValue(int n, Memory memory) {
        try {
            this.writeIndex[n] = memory;
        }
        catch (NullPointerException nullPointerException) {
            this.getWriteIndex()[n] = memory;
        }
    }

    private Memory getWriteIndexValue(int n) {
        try {
            return this.writeIndex[n];
        }
        catch (NullPointerException nullPointerException) {
            return this.getWriteIndex()[n];
        }
    }

    public int getLastWalkedAddress() {
        return this.lastAddress;
    }

    public boolean isSupervisor() {
        return this.isSupervisor;
    }

    public void setSupervisor(boolean bl) {
        this.isSupervisor = bl;
        if (this.isSupervisor) {
            this.readIndex = this.readSupervisorIndex;
            this.writeIndex = this.writeSupervisorIndex;
        } else {
            this.readIndex = this.readUserIndex;
            this.writeIndex = this.writeUserIndex;
        }
    }

    public boolean isPagingEnabled() {
        return !this.pagingDisabled;
    }

    public void setPagingEnabled(boolean bl) {
        if (bl && !((PhysicalAddressSpace)this.target).getGateA20State()) {
            System.err.println("PAGING with GateA20 Masked!!!");
        }
        this.pagingDisabled = !bl;
        this.flush();
    }

    public void setPageCacheEnabled(boolean bl) {
        this.pageCacheEnabled = bl;
    }

    public void setPageSizeExtensionsEnabled(boolean bl) {
        this.pageSizeExtensions = bl;
        this.flush();
    }

    public void setPageWriteThroughEnabled(boolean bl) {
    }

    public void setGlobalPagesEnabled(boolean bl) {
        if (this.globalPagesEnabled == bl) {
            return;
        }
        this.globalPagesEnabled = bl;
        this.flush();
    }

    public void setWriteProtectUserPages(boolean bl) {
        if (bl) {
            for (int i = 0; i < 0x100000; ++i) {
                this.nullIndex(this.writeSupervisorIndex, i);
            }
        }
        this.writeProtectUserPages = bl;
    }

    public boolean pagingDisabled() {
        return this.pagingDisabled;
    }

    public void flush() {
        for (int i = 0; i < 0x100000; ++i) {
            this.pageFlags[i] = 0;
        }
        this.nonGlobalPages.clear();
        this.readUserIndex = null;
        this.writeUserIndex = null;
        this.readSupervisorIndex = null;
        this.writeSupervisorIndex = null;
    }

    private void partialFlush() {
        if (!this.globalPagesEnabled) {
            this.flush();
            return;
        }
        Enumeration<Integer> enumeration = this.nonGlobalPages.keys();
        while (enumeration.hasMoreElements()) {
            int n = enumeration.nextElement();
            this.nullIndex(this.readSupervisorIndex, n);
            this.nullIndex(this.writeSupervisorIndex, n);
            this.nullIndex(this.readUserIndex, n);
            this.nullIndex(this.writeUserIndex, n);
            this.pageFlags[n] = 0;
        }
        this.nonGlobalPages.clear();
    }

    private void nullIndex(Memory[] memoryArray, int n) {
        try {
            memoryArray[n] = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setPageDirectoryBaseAddress(int n) {
        this.baseAddress = n & 0xFFFFF000;
        this.partialFlush();
    }

    public void invalidateTLBEntry(int n) {
        int n2 = n >>> 12;
        if ((this.pageFlags[n2] & 2) == 0) {
            this.nullIndex(this.readSupervisorIndex, n2);
            this.nullIndex(this.writeSupervisorIndex, n2);
            this.nullIndex(this.readUserIndex, n2);
            this.nullIndex(this.writeUserIndex, n2);
            this.nonGlobalPages.remove(new Integer(n2));
        } else {
            n2 = (n & 0xFFC00000) >>> 12;
            int n3 = 0;
            while (n3 < 1024) {
                this.nullIndex(this.readSupervisorIndex, n2);
                this.nullIndex(this.writeSupervisorIndex, n2);
                this.nullIndex(this.readUserIndex, n2);
                this.nullIndex(this.writeUserIndex, n2);
                this.nonGlobalPages.remove(new Integer(n2));
                ++n3;
                ++n2;
            }
        }
    }

    public Memory validateTLBEntryRead(int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int n2 = n >>> 12;
        if (this.pagingDisabled) {
            this.setReadIndexValue(n2, this.target.getReadMemoryBlockAt(n));
            return this.readIndex[n2];
        }
        this.lastAddress = n;
        int n3 = this.baseAddress | 0xFFC & n >>> 20;
        int n4 = this.target.getDoubleWord(n3);
        boolean bl5 = bl4 = (1 & n4) != 0;
        if (!bl4) {
            if (this.isSupervisor) {
                return PF_NOT_PRESENT_RS;
            }
            return PF_NOT_PRESENT_RU;
        }
        boolean bl6 = this.globalPagesEnabled && (0x100 & n4) != 0;
        boolean bl7 = (2 & n4) != 0;
        boolean bl8 = (4 & n4) != 0;
        boolean bl9 = bl3 = (0x80 & n4) != 0 && this.pageSizeExtensions;
        if (bl3) {
            if (!bl8 && !this.isSupervisor) {
                return PF_PROTECTION_VIOLATION_RU;
            }
            if ((n4 & 0x20) == 0) {
                this.target.setDoubleWord(n3, n4 |= 0x20);
            }
            int n5 = 0xFFC00000 & n4;
            int n6 = 2;
            if (bl6) {
                n6 = 3;
            }
            if (!this.pageCacheEnabled) {
                return this.target.getReadMemoryBlockAt(n5 | n & 0x3FFFFF);
            }
            int n7 = (0xFFC00000 & n) >>> 12;
            for (int i = 0; i < 1024; ++i) {
                Memory memory = this.target.getReadMemoryBlockAt(n5);
                n5 += 4096;
                this.pageFlags[n7] = n6;
                this.setReadIndexValue(n7++, memory);
                if (bl6) continue;
                Integer n8 = new Integer(i);
                this.nonGlobalPages.put(n8, n8);
            }
            return this.readIndex[n2];
        }
        int n9 = n4 & 0xFFFFF000;
        boolean bl10 = (8 & n4) != 0;
        boolean bl11 = (0x10 & n4) != 0;
        boolean bl12 = (0x40 & n4) != 0;
        int n10 = n9 | n >>> 10 & 0xFFC;
        int n11 = this.target.getDoubleWord(n10);
        boolean bl13 = bl2 = (1 & n11) != 0;
        if (!bl2) {
            if (this.isSupervisor) {
                return PF_NOT_PRESENT_RS;
            }
            return PF_NOT_PRESENT_RU;
        }
        boolean bl14 = this.globalPagesEnabled && (0x100 & n11) != 0;
        boolean bl15 = (2 & n11) != 0;
        boolean bl16 = (4 & n11) != 0;
        boolean bl17 = bl16 && bl8;
        boolean bl18 = bl = bl15 || bl7;
        if (bl17) {
            boolean bl19 = bl = bl15 && bl7;
        }
        if (!bl17 && !this.isSupervisor) {
            return PF_PROTECTION_VIOLATION_RU;
        }
        if ((n11 & 0x20) == 0) {
            this.target.setDoubleWord(n10, n11 |= 0x20);
        }
        int n12 = n11 & 0xFFFFF000;
        if (!this.pageCacheEnabled) {
            return this.target.getReadMemoryBlockAt(n12);
        }
        if (bl14) {
            this.pageFlags[n2] = 1;
        } else {
            this.pageFlags[n2] = 0;
            Integer n13 = new Integer(n2);
            this.nonGlobalPages.put(n13, n13);
        }
        this.setReadIndexValue(n2, this.target.getReadMemoryBlockAt(n12));
        return this.readIndex[n2];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Memory validateTLBEntryWrite(int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int n2 = n >>> 12;
        if (this.pagingDisabled) {
            this.setWriteIndexValue(n2, this.target.getWriteMemoryBlockAt(n));
            return this.writeIndex[n2];
        }
        this.lastAddress = n;
        int n3 = this.baseAddress | 0xFFC & n >>> 20;
        int n4 = this.target.getDoubleWord(n3);
        boolean bl5 = bl4 = (1 & n4) != 0;
        if (!bl4) {
            if (!this.isSupervisor) return PF_NOT_PRESENT_WU;
            return PF_NOT_PRESENT_WS;
        }
        boolean bl6 = this.globalPagesEnabled && (0x100 & n4) != 0;
        boolean bl7 = (2 & n4) != 0;
        boolean bl8 = (4 & n4) != 0;
        boolean bl9 = bl3 = (0x80 & n4) != 0 && this.pageSizeExtensions;
        if (bl3) {
            if (bl8) {
                if (!bl7) {
                    if (!this.isSupervisor) return PF_PROTECTION_VIOLATION_WU;
                    if (this.writeProtectUserPages) {
                        return PF_PROTECTION_VIOLATION_WS;
                    }
                }
            } else if (bl7) {
                if (!this.isSupervisor) {
                    return PF_PROTECTION_VIOLATION_WU;
                }
            } else {
                if (!this.isSupervisor) return PF_PROTECTION_VIOLATION_WU;
                return PF_PROTECTION_VIOLATION_WS;
            }
            if ((n4 & 0x60) != 96) {
                this.target.setDoubleWord(n3, n4 |= 0x60);
            }
            int n5 = 0xFFC00000 & n4;
            int n6 = 2;
            if (bl6) {
                n6 = 3;
            }
            if (!this.pageCacheEnabled) {
                return this.target.getWriteMemoryBlockAt(n5 | n & 0x3FFFFF);
            }
            int n7 = (0xFFC00000 & n) >>> 12;
            for (int i = 0; i < 1024; ++i) {
                Memory memory = this.target.getWriteMemoryBlockAt(n5);
                n5 += 4096;
                this.pageFlags[n7] = n6;
                this.setWriteIndexValue(n7++, memory);
                if (bl6) continue;
                Integer n8 = new Integer(i);
                this.nonGlobalPages.put(n8, n8);
            }
            return this.writeIndex[n2];
        }
        int n9 = n4 & 0xFFFFF000;
        boolean bl10 = (8 & n4) != 0;
        boolean bl11 = (0x10 & n4) != 0;
        boolean bl12 = (0x40 & n4) != 0;
        int n10 = n9 | n >>> 10 & 0xFFC;
        int n11 = this.target.getDoubleWord(n10);
        boolean bl13 = bl2 = (1 & n11) != 0;
        if (!bl2) {
            if (!this.isSupervisor) return PF_NOT_PRESENT_WU;
            return PF_NOT_PRESENT_WS;
        }
        boolean bl14 = this.globalPagesEnabled && (0x100 & n11) != 0;
        boolean bl15 = (2 & n11) != 0;
        boolean bl16 = (4 & n11) != 0;
        boolean bl17 = bl16 && bl8;
        boolean bl18 = bl = bl15 || bl7;
        if (bl17) {
            boolean bl19 = bl = bl15 && bl7;
        }
        if (bl17) {
            if (!bl) {
                if (!this.isSupervisor) return PF_PROTECTION_VIOLATION_WU;
                if (this.writeProtectUserPages) {
                    return PF_PROTECTION_VIOLATION_WS;
                }
            }
        } else if (bl) {
            if (!this.isSupervisor) {
                return PF_PROTECTION_VIOLATION_WU;
            }
        } else {
            if (!this.isSupervisor) return PF_PROTECTION_VIOLATION_WU;
            return PF_PROTECTION_VIOLATION_WS;
        }
        if ((n11 & 0x60) != 96) {
            this.target.setDoubleWord(n10, n11 |= 0x60);
        }
        int n12 = n11 & 0xFFFFF000;
        if (!this.pageCacheEnabled) {
            return this.target.getWriteMemoryBlockAt(n12);
        }
        if (bl14) {
            this.pageFlags[n2] = 1;
        } else {
            this.pageFlags[n2] = 0;
            Integer n13 = new Integer(n2);
            this.nonGlobalPages.put(n13, n13);
        }
        this.setWriteIndexValue(n2, this.target.getWriteMemoryBlockAt(n12));
        return this.writeIndex[n2];
    }

    @Override
    public Memory getReadMemoryBlockAt(int n) {
        return this.getReadIndexValue(n >>> 12);
    }

    @Override
    public Memory getWriteMemoryBlockAt(int n) {
        return this.getWriteIndexValue(n >>> 12);
    }

    @Override
    void replaceBlocks(Memory memory, Memory memory2) {
        int n;
        try {
            for (n = 0; n < 0x100000; ++n) {
                if (this.readUserIndex[n] != memory) continue;
                this.readUserIndex[n] = memory2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (n = 0; n < 0x100000; ++n) {
                if (this.writeUserIndex[n] != memory) continue;
                this.writeUserIndex[n] = memory2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (int i = 0; i < 0x100000; ++i) {
                if (this.readSupervisorIndex[i] != memory) continue;
                this.readSupervisorIndex[i] = memory2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            for (int i = 0; i < 0x100000; ++i) {
                if (this.writeSupervisorIndex[i] != memory) continue;
                this.writeSupervisorIndex[i] = memory2;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public byte getByte(int n) {
        try {
            return super.getByte(n);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        return this.validateTLBEntryRead(n).getByte(n & 0xFFF);
    }

    @Override
    public short getWord(int n) {
        try {
            return super.getWord(n);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        Memory memory = this.validateTLBEntryRead(n);
        try {
            return memory.getWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.getWordInBytes(n);
        }
    }

    @Override
    public int getDoubleWord(int n) {
        try {
            return super.getDoubleWord(n);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        Memory memory = this.validateTLBEntryRead(n);
        try {
            return memory.getDoubleWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.getDoubleWordInBytes(n);
        }
    }

    @Override
    public void setByte(int n, byte by) {
        try {
            super.setByte(n, by);
            return;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        this.validateTLBEntryWrite(n).setByte(n & 0xFFF, by);
    }

    @Override
    public void setWord(int n, short s) {
        try {
            super.setWord(n, s);
            return;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        Memory memory = this.validateTLBEntryWrite(n);
        try {
            memory.setWord(n & 0xFFF, s);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.setWordInBytes(n, s);
        }
    }

    @Override
    public void setDoubleWord(int n, int n2) {
        try {
            super.setDoubleWord(n, n2);
            return;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ProcessorException processorException) {
            // empty catch block
        }
        Memory memory = this.validateTLBEntryWrite(n);
        try {
            memory.setDoubleWord(n & 0xFFF, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.setDoubleWordInBytes(n, n2);
        }
    }

    @Override
    public void clear() {
        this.target.clear();
    }

    @Override
    public int execute(Processor processor, int n) {
        Memory memory = this.getReadMemoryBlockAt(n);
        try {
            return memory.execute(processor, n & 0xFFF);
        }
        catch (NullPointerException nullPointerException) {
            memory = this.validateTLBEntryRead(n);
        }
        catch (ProcessorException processorException) {
            memory = this.validateTLBEntryRead(n);
        }
        try {
            return memory.execute(processor, n & 0xFFF);
        }
        catch (ProcessorException processorException) {
            processor.handleProtectedModeException(processorException.getVector(), processorException.hasErrorCode(), processorException.getErrorCode());
            return 1;
        }
    }

    @Override
    public CodeBlock decodeCodeBlockAt(Processor processor, int n) {
        Memory memory = this.getReadMemoryBlockAt(n);
        try {
            return memory.decodeCodeBlockAt(processor, n & 0xFFF);
        }
        catch (NullPointerException nullPointerException) {
            memory = this.validateTLBEntryRead(n);
        }
        catch (ProcessorException processorException) {
            memory = this.validateTLBEntryRead(n);
        }
        CodeBlock codeBlock = memory.decodeCodeBlockAt(processor, n & 0xFFF);
        return codeBlock;
    }

    @Override
    public boolean reset() {
        this.flush();
        this.baseAddress = 0;
        this.lastAddress = 0;
        this.pagingDisabled = true;
        this.globalPagesEnabled = false;
        this.writeProtectUserPages = false;
        this.pageSizeExtensions = false;
        this.readUserIndex = null;
        this.writeUserIndex = null;
        this.readSupervisorIndex = null;
        this.writeSupervisorIndex = null;
        return true;
    }

    @Override
    public boolean updated() {
        return this.target.updated();
    }

    @Override
    public void updateComponent(HardwareComponent hardwareComponent) {
    }

    @Override
    public boolean initialised() {
        return this.target != null;
    }

    @Override
    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.target = (AddressSpace)((Object)hardwareComponent);
        }
    }

    @Override
    public void timerCallback() {
    }

    public String toString() {
        return "Linear Address Space";
    }

    public static final class PageFaultWrapper
    extends Memory {
        private ProcessorException pageFault;

        public PageFaultWrapper(int n) {
            this.pageFault = new ProcessorException(14, n, true);
        }

        private final void fill() {
        }

        public ProcessorException getFault() {
            return this.pageFault;
        }

        @Override
        public void clear() {
        }

        @Override
        public void clear(int n, int n2) {
        }

        @Override
        public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public long getSize() {
            return 0L;
        }

        @Override
        public byte getByte(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public short getWord(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public int getDoubleWord(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public long getQuadWord(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public long getLowerDoubleQuadWord(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public long getUpperDoubleQuadWord(int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setByte(int n, byte by) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setWord(int n, short s) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setDoubleWord(int n, int n2) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setQuadWord(int n, long l) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setLowerDoubleQuadWord(int n, long l) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public void setUpperDoubleQuadWord(int n, long l) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public int execute(Processor processor, int n) {
            this.fill();
            throw this.pageFault;
        }

        @Override
        public CodeBlock decodeCodeBlockAt(Processor processor, int n) {
            this.fill();
            throw this.pageFault;
        }
    }
}

